//---------------------------------------------------------
#include <vcl.h>
#include <sysopen.h>
#pragma hdrstop
#include "usb_R6_4.h"
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
bool (__stdcall *HidD_GetAttributes)(IN HANDLE HidDeviceObject,
                                     OUT PHIDD_ATTRIBUTES Attributes);
long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);

bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                      OUT PHIDP_PREPARSED_DATA *PreparsedData);

bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);

//---------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
   memberIndex = 0;
   deviceInterfaceDetailData = NULL;
   numberOfBytesRead = 0;
   hidDeviceObject = INVALID_HANDLE_VALUE;

   hHidLib = LoadLibrary("C:\\Windows\\System32\\HID.DLL");
   if (!hHidLib)
     displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
   (FARPROC&) HidD_GetAttributes=GetProcAddress(hHidLib, "HidD_GetAttributes");
   (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
   (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
   (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");


   if (!HidD_GetHidGuid) {
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   Canvas->Pen->Mode = pmNotXor;
   Canvas->Pen->Color = clRed;
   Canvas->Pen->Width = 3;
}
//---------------------------------------------------------
void __fastcall TForm1::displayError(const char* msg){
   ShowMessage(msg);
   exit(0);
};
//---------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          FreeLibrary(hHidLib);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
          ShowMessage(deviceInterfaceDetailData->DevicePath);
          hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
          if(hidDeviceObject==INVALID_HANDLE_VALUE)
             displayError("Nie mona otworzy urzdzenia do transmisji");
             else
               break;

       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   showCapabilitiesDevice(this);
   bool marker=false;
   while(true) {
        ReadFile(hidDeviceObject, inputReportBuffer, sizeof(inputReportBuffer),
                 &numberOfBytesRead, NULL);
        if (marker==true)
           Canvas->Polyline(points,3); //zamazuje trjt
        marker=true;
        points[0].x = 2*inputReportBuffer[1]+ClientHeight/2;
        points[0].y = 270;
        points[1].x = 2*inputReportBuffer[1]+75+ClientHeight/2;
        points[1].y = 270;
        points[2].x = 2*inputReportBuffer[1]+37+ClientHeight/2;
        points[2].y = 310;
        points[3].x = 2*inputReportBuffer[1]+ClientHeight/2;
        points[3].y = 270;
        // rysuje trjkt
        Canvas->Polyline(points,3);
        TrackBar1->Position = inputReportBuffer[1];
        ProgressBar1->Position = inputReportBuffer[1];
        if(inputReportBuffer[6]==64 || hidDeviceObject == INVALID_HANDLE_VALUE){
           ShowMessage("Odczyt zakoczony. Moesz bezpiecznie"
                       " zamkn aplikacj.");
           break;
        }
   }//koniec while
}
//---------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender,
                                  TCloseAction &Action)
{
   if(hidDeviceObject != INVALID_HANDLE_VALUE)
      Win32Check(CloseHandle(hidDeviceObject));
   FreeLibrary(hHidLib);
   Action = caFree;
}
//---------------------------------------------------------
void __fastcall TForm1::showCapabilitiesDevice(TObject *Sender)
{
   HidD_GetAttributes(hidDeviceObject, &hiddAttributes);

   AnsiString S = S.Format("VID-PID-Wersja = %x-%x-%x",
                    OPENARRAY(TVarRec,(hiddAttributes.VendorID,
                    hiddAttributes.ProductID, hiddAttributes.VersionNumber)));
   Memo1->Lines->Add(S);

   HidD_GetPreparsedData(hidDeviceObject, &preparsedData);
   HidP_GetCaps(preparsedData, &capabilities);

   AnsiString S1 = S1.Format("Usage=%d UsagePage=%d\
       InputReportByteLength=%d OutputReportByteLength=%d\
       FeatureReportByteLength=%d NumberInputButtonCaps=%d\
       NumberInputValueCaps=%d NumberInputDataIndices=%d\
       NumberOutputButtonCaps=%d NumberOutputValueCaps=%d\
       NumberOutputButtonCaps=%d NumberOutputValueCaps=%d\
       NumberOutputDataIndices=%d NumberFeatureButtonCaps=%d\
       NumberFeatureValueCaps=%d NumberFeatureDataIndices=%d",
       OPENARRAY(TVarRec,(capabilities.Usage, capabilities.UsagePage,
                          capabilities.InputReportByteLength,
                          capabilities.OutputReportByteLength,
                          capabilities.FeatureReportByteLength,
                          capabilities.NumberInputButtonCaps,
                          capabilities.NumberInputValueCaps,
                          capabilities.NumberInputDataIndices,
                          capabilities.NumberOutputButtonCaps,
                          capabilities.NumberOutputValueCaps,
                          capabilities.NumberOutputButtonCaps,
                          capabilities.NumberOutputValueCaps,
                          capabilities.NumberOutputDataIndices,
                          capabilities.NumberFeatureButtonCaps,
                          capabilities.NumberFeatureValueCaps,
                          capabilities.NumberFeatureDataIndices)));

   Memo1->Lines->Add(S1);

   HidD_FreePreparsedData(preparsedData);
}
//---------------------------------------------------------



